/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8281;

import ibm.nways.jdm.DestinationPropBook;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.common.IPAddress;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.eui.JDMWizardInfo;
import ibm.nways.jdm.eui.JDMWizardPanelDelegate;
import ibm.nways.jdm.eui.MessageBox;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.ras.RAS;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;

public class TrapSubscCreate
implements JDMWizardPanelDelegate {
    private static ResourceBundle myResources = ResourceBundle.getBundle("ibm.nways.jdm8281.Resources");
    private static int MaxTrunks = 8;
    private static final int RASID = 19;
    private static final int RASSUB = 12;
    DestinationPropBook myBook;
    JdmBrowser browser;
    GenModel device_Model;
    NavigationContext myContext;
    MessageBox messageToUser;

    public void setDefaults(JDMWizardInfo jDMWizardInfo) {
        IPAddress iPAddress = new IPAddress("0.0.0.0");
        Hashtable hashtable = jDMWizardInfo.getItems();
        hashtable.put("newAtmBrTrapSubscriptIpAddress", iPAddress);
        hashtable.put("newAtmBrTrapSubscriptCommunity", "");
    }

    public boolean abort(JDMWizardInfo jDMWizardInfo) {
        return true;
    }

    public boolean proceed(JDMWizardInfo jDMWizardInfo) {
        boolean bl = true;
        GenModel genModel = null;
        ModelInfo modelInfo = null;
        int n = 0;
        String string = null;
        Hashtable hashtable = null;
        if (RAS.isEnabled(19, 12)) {
            RAS.trace(19, 12, this, "proceed", "proceed");
        }
        long l = System.currentTimeMillis();
        this.myBook = (DestinationPropBook)jDMWizardInfo.getPropertyBook();
        if (this.browser == null && this.myBook != null) {
            this.browser = (JdmBrowser)this.myBook.getBrowser();
        }
        if (this.browser == null) {
            if (RAS.isEnabled(19, 12)) {
                RAS.trace(19, 12, this, "proceed", "8281: No browser available");
            }
            bl = false;
        }
        if (bl) {
            if (RAS.isEnabled(19, 12)) {
                RAS.trace(19, 12, this, "proceed", "DL:TrapSubscCreate Proceed entry.");
            }
            hashtable = jDMWizardInfo.getItems();
        }
        if (bl) {
            if (this.device_Model == null) {
                this.device_Model = (GenModel)this.browser.getModel();
            }
            try {
                genModel = jDMWizardInfo.getModel();
                Vector vector = genModel.getRestOfInfo("Panel", "default", null, null);
                if (RAS.isEnabled(19, 12)) {
                    RAS.trace(19, 12, this, "proceed", "###  rows.size() = " + vector.size());
                }
                n = vector.size() + 1;
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    modelInfo = (ModelInfo)enumeration.nextElement();
                    Serializable serializable = modelInfo.get("Panel.AtmBrTrapSubscriptIpAddress");
                    if (!(serializable instanceof IPAddress) || !((IPAddress)serializable).toString().equals("0.0.0.0")) continue;
                    if (RAS.isEnabled(19, 12)) {
                        RAS.trace(19, 12, this, "proceed", "Found zero IP");
                    }
                    serializable = modelInfo.get("Panel.AtmBrTrapSubscriptIndex");
                    n = (Integer)serializable;
                    break;
                }
            }
            catch (Exception exception) {
                if (RAS.isEnabled(19, 12)) {
                    RAS.trace(19, 12, this, "proceed", "DL: Trap subscription Create - can't get model/info to get nextFreeIndex for row creation");
                }
                RAS.logException(19, 12, this, "proceed", exception);
                string = new String("WZ_getError");
                bl = false;
            }
        }
        if (bl) {
            if (RAS.isEnabled(19, 12)) {
                RAS.trace(19, 12, this, "proceed", "### Createing row  " + n);
            }
            genModel = jDMWizardInfo.getModel();
            modelInfo = new ModelInfo();
            modelInfo.add("Index.AtmBrTrapSubscriptIndex", new Integer(n));
            modelInfo.add("Panel.AtmBrTrapSubscriptIpAddress", (Serializable)hashtable.get("newAtmBrTrapSubscriptIpAddress"));
            modelInfo.add("Panel.AtmBrTrapSubscriptCommunity", (Serializable)hashtable.get("newAtmBrTrapSubscriptCommunity"));
            modelInfo.add("Panel.AtmBrTrapSubscriptActions", new Integer(2));
            try {
                modelInfo = genModel.setInfo("Panel", modelInfo);
                bl = this.checkSnmpResponse(modelInfo);
                if (!bl) {
                    string = new String("WZ_badSet");
                }
            }
            catch (Exception exception) {
                bl = false;
                string = new String("WZ_badSet");
                if (RAS.isEnabled(19, 12)) {
                    RAS.trace(19, 12, this, "proceed", "DL: Exception setting Trap Subscriber");
                }
                RAS.logException(19, 12, this, "proceed", exception);
            }
        }
        if (!bl && this.browser != null) {
            this.browser.displayMsg(TrapSubscCreate.getNLSString(string));
            this.messageToUser = new MessageBox(this.browser.getFrame(), TrapSubscCreate.getNLSString("TC_error"), TrapSubscCreate.getNLSString(string), true);
        }
        long l2 = System.currentTimeMillis();
        if (RAS.isEnabled(19, 12)) {
            RAS.trace(19, 12, this, "proceed", "Finished device picture in " + String.valueOf(l2 - l) + " msecs");
        }
        return bl;
    }

    protected static String getNLSString(String string) {
        String string2 = null;
        try {
            string2 = myResources.getString(string);
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string2;
    }

    private boolean checkSnmpResponse(ModelInfo modelInfo) {
        boolean bl = false;
        Enumeration enumeration = modelInfo.getItemIds();
        while (enumeration.hasMoreElements()) {
            bl = true;
            String string = (String)enumeration.nextElement();
            Serializable serializable = modelInfo.get(string);
            if (!(serializable instanceof SpecialValue)) continue;
            if (RAS.isEnabled(19, 12)) {
                RAS.trace(19, 12, this, "checkSnmpResponse", "DL: Error in snmp set. Variable is " + string + "  SpecialValue is " + serializable);
            }
            bl = false;
            break;
        }
        return bl;
    }
}

